using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace CustomOclOperations
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private CustomOclOperationsEcoSpace m_EcoSpace;
		private Borland.Eco.Handles.ExpressionHandle ehAllPersons;
		private System.Windows.Forms.DataGrid grdAllPersons;
		private System.Windows.Forms.Button btnAddPerson;
		private Borland.Eco.Handles.CurrencyManagerHandle cmhAllPersons;
		private Borland.Eco.Handles.ExpressionHandle ehAccounts;
		private System.Windows.Forms.DataGrid grdAccounts;
		private System.Windows.Forms.Button btnAddAccount;
		private System.Windows.Forms.Button btnDisconnect;
		private System.Windows.Forms.Button btnReconnect;
		public CustomOclOperationsEcoSpace EcoSpace
		{
			get { return m_EcoSpace; }
		}

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			m_EcoSpace = new CustomOclOperationsEcoSpace();
			rhRoot.EcoSpace = m_EcoSpace;
			// The line below will automatically activate the ECO Space on form creation.
			// Remove the line if you wish to activate the EcoSpace manually
			m_EcoSpace.Active = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.OclColumn oclColumn11 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn12 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.OclColumn oclColumn13 = new Borland.Eco.Handles.OclColumn();
			Borland.Eco.Handles.Column column11 = new Borland.Eco.Handles.Column();
			Borland.Eco.Handles.Column column12 = new Borland.Eco.Handles.Column();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.btnAddPerson = new System.Windows.Forms.Button();
			this.grdAllPersons = new System.Windows.Forms.DataGrid();
			this.ehAllPersons = new Borland.Eco.Handles.ExpressionHandle();
			this.btnAddAccount = new System.Windows.Forms.Button();
			this.grdAccounts = new System.Windows.Forms.DataGrid();
			this.ehAccounts = new Borland.Eco.Handles.ExpressionHandle();
			this.cmhAllPersons = new Borland.Eco.Handles.CurrencyManagerHandle();
			this.btnDisconnect = new System.Windows.Forms.Button();
			this.btnReconnect = new System.Windows.Forms.Button();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			((System.ComponentModel.ISupportInitialize)(this.grdAllPersons)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.grdAccounts)).BeginInit();
			this.SuspendLayout();
			// 
			// rhRoot
			// 
			this.rhRoot.EcoSpaceType = typeof(CustomOclOperations.CustomOclOperationsEcoSpace);
			// 
			// btnAddPerson
			// 
			this.btnAddPerson.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.EcoListActions.SetBindingContext(this.btnAddPerson, this.grdAllPersons);
			this.EcoListActions.SetEcoListAction(this.btnAddPerson, Borland.Eco.WinForm.ListAction.Add);
			this.btnAddPerson.ImageIndex = 1;
			this.btnAddPerson.Location = new System.Drawing.Point(344, 8);
			this.btnAddPerson.Name = "btnAddPerson";
			this.EcoListActions.SetRootHandle(this.btnAddPerson, this.ehAllPersons);
			this.btnAddPerson.Size = new System.Drawing.Size(72, 23);
			this.btnAddPerson.TabIndex = 1;
			this.btnAddPerson.Text = "Add";
			// 
			// grdAllPersons
			// 
			this.grdAllPersons.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
						| System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.grdAllPersons.CaptionText = "All persons";
			this.grdAllPersons.DataMember = "";
			this.grdAllPersons.DataSource = this.ehAllPersons;
			this.EcoAutoForms.SetEcoAutoForm(this.grdAllPersons, true);
			this.grdAllPersons.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.grdAllPersons.Location = new System.Drawing.Point(8, 8);
			this.grdAllPersons.Name = "grdAllPersons";
			this.grdAllPersons.Size = new System.Drawing.Size(328, 128);
			this.grdAllPersons.TabIndex = 0;
			// 
			// ehAllPersons
			// 
			oclColumn11.Expression = "self.Name.reverseString";
			oclColumn11.Name = "ReverseName";
			oclColumn12.Expression = "self.Accounts.assets->standardDeviation";
			oclColumn12.Name = "StdDev";
			oclColumn13.Expression = "self.Accounts.Assets->sum";
			oclColumn13.Name = "Assets";
			this.ehAllPersons.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						oclColumn11,
						oclColumn12,
						oclColumn13});
			this.ehAllPersons.Expression = "Person.allInstances";
			this.ehAllPersons.RootHandle = this.rhRoot;
			// 
			// btnAddAccount
			// 
			this.btnAddAccount.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.EcoListActions.SetBindingContext(this.btnAddAccount, this.grdAccounts);
			this.EcoListActions.SetEcoListAction(this.btnAddAccount, Borland.Eco.WinForm.ListAction.Add);
			this.btnAddAccount.ImageIndex = 1;
			this.btnAddAccount.Location = new System.Drawing.Point(344, 152);
			this.btnAddAccount.Name = "btnAddAccount";
			this.EcoListActions.SetRootHandle(this.btnAddAccount, this.ehAccounts);
			this.btnAddAccount.Size = new System.Drawing.Size(72, 23);
			this.btnAddAccount.TabIndex = 3;
			this.btnAddAccount.Text = "Add";
			// 
			// grdAccounts
			// 
			this.grdAccounts.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
			this.grdAccounts.CaptionText = "Accounts of selected person";
			this.grdAccounts.DataMember = "";
			this.grdAccounts.DataSource = this.ehAccounts;
			this.EcoAutoForms.SetEcoAutoForm(this.grdAccounts, true);
			this.grdAccounts.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.grdAccounts.Location = new System.Drawing.Point(8, 152);
			this.grdAccounts.Name = "grdAccounts";
			this.grdAccounts.Size = new System.Drawing.Size(328, 104);
			this.grdAccounts.TabIndex = 2;
			// 
			// ehAccounts
			// 
			this.ehAccounts.AddDefaultProperties = false;
			column11.Expression = "self.Assets";
			column11.Name = "Assets";
			column12.Expression = "self.Person.Name";
			column12.Name = "Owner";
			this.ehAccounts.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						column11,
						column12});
			this.ehAccounts.Expression = "Accounts";
			this.ehAccounts.RootHandle = this.cmhAllPersons;
			// 
			// cmhAllPersons
			// 
			this.cmhAllPersons.BindingContext = this.grdAllPersons;
			this.cmhAllPersons.RootHandle = this.ehAllPersons;
			// 
			// btnDisconnect
			// 
			this.btnDisconnect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDisconnect.Location = new System.Drawing.Point(344, 200);
			this.btnDisconnect.Name = "btnDisconnect";
			this.btnDisconnect.Size = new System.Drawing.Size(72, 24);
			this.btnDisconnect.TabIndex = 4;
			this.btnDisconnect.Text = "Disconnect";
			this.btnDisconnect.Click += new System.EventHandler(this.btnDisconnect_Click);
			// 
			// btnReconnect
			// 
			this.btnReconnect.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnReconnect.Location = new System.Drawing.Point(344, 232);
			this.btnReconnect.Name = "btnReconnect";
			this.btnReconnect.Size = new System.Drawing.Size(72, 23);
			this.btnReconnect.TabIndex = 5;
			this.btnReconnect.Text = "Reconnect";
			this.btnReconnect.Click += new System.EventHandler(this.btnReconnect_Click);
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(424, 266);
			this.Controls.Add(this.btnReconnect);
			this.Controls.Add(this.btnDisconnect);
			this.Controls.Add(this.btnAddAccount);
			this.Controls.Add(this.grdAccounts);
			this.Controls.Add(this.btnAddPerson);
			this.Controls.Add(this.grdAllPersons);
			this.Name = "WinForm";
			this.Text = "ECO Demo - Custom OCL operations";
			((System.ComponentModel.ISupportInitialize)(this.grdAllPersons)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.grdAccounts)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		[STAThread]
		static void Main()
		{
			WinFormDequeuer.Active = true;
			Application.Run(new WinForm());
		}

		private void btnDisconnect_Click(object sender, System.EventArgs e)
		{
			ehAllPersons.Enabled = false;
		}

		private void btnReconnect_Click(object sender, System.EventArgs e)
		{
			ehAllPersons.Enabled = true;
		}
	}
}
